% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms.codes}
\alias{microorganisms.codes}
\title{Data Set with 5 910 Common Microorganism Codes}
\format{
A \link[tibble:tibble]{tibble} with 5 910 observations and 2 variables:
\itemize{
\item \code{code}\cr Commonly used code of a microorganism
\item \code{mo}\cr ID of the microorganism in the \link{microorganisms} data set
}
}
\usage{
microorganisms.codes
}
\description{
A data set containing commonly used codes for microorganisms, from laboratory systems and WHONET. Define your own with \code{\link[=set_mo_source]{set_mo_source()}}. They will all be searched when using \code{\link[=as.mo]{as.mo()}} and consequently all the \code{\link[=mo_property]{mo_*}} functions.
}
\details{
Like all data sets in this package, this data set is publicly available for download in the following formats: R, MS Excel, Apache Feather, Apache Parquet, SPSS, SAS, and Stata. Please visit \href{https://msberends.github.io/AMR/articles/datasets.html}{our website for the download links}. The actual files are of course available on \href{https://github.com/msberends/AMR/tree/main/data-raw}{our GitHub repository}.
}
\examples{
microorganisms.codes
}
\seealso{
\code{\link[=as.mo]{as.mo()}} \link{microorganisms}
}
\keyword{datasets}
