% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mood.R
\name{mood}
\alias{mood}
\title{Perform Mood test}
\usage{
mood(
  x,
  y,
  H0 = NULL,
  alternative = c("two.sided", "less", "greater"),
  max.exact.cases = 25,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector}

\item{H0}{Null hypothesis value (defaults to \code{NULL})}

\item{alternative}{Type of alternative hypothesis (defaults to \code{two.sided})}

\item{max.exact.cases}{Maximum number of cases allowed for exact calculations (defaults to \code{25})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{mood()} performs the Mood test and is used in chapter 6 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 6.12 from "Applied Nonparametric Statistical Methods" (5th edition)
mood(ch6$typeA, ch6$typeB)
mood(ch6$typeA, ch6$typeB, do.exact = FALSE, do.asymp = TRUE)

}
