% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.tauKrPartialPermSig.R
\name{stat.tauKrPartialPermSig}
\alias{stat.tauKrPartialPermSig}
\title{Partial matrix TauKr correlations}
\usage{
stat.tauKrPartialPermSig(X, Y, Z, nperm, omitDiag = TRUE)
}
\arguments{
\item{X}{a square matrix of individual interactions or associations}

\item{Y}{a square matrix of individual interactions or attributes}

\item{Z}{a square matrix of individual interactions or attributes to use as a control in the matrix correlation between X and Y}

\item{nperm}{number of permutations.}

\item{omitDiag}{boolean to omit or not the diagonal from the matrices}
}
\value{
a list with the correlation coefficients 1) TauKrxy, 2) TauKrxz, 3) TauKryz, 4) TauKrxyz; p-values of the TauKrxyz coefficient value 5) on the right, 6) on the left
}
\description{
Partial Matrix TauKr correlation with significant test.
}
\references{
Hemelrijk, C. K. 1990. A matrix partial correlation test used in investigations of reciprocity and other social interaction patterns at a group level. Journal of theoretical Biology, 143, 405-420.
}
\author{
Ivan Puga-Gonzalez, Sebastian Sosa.
}
\keyword{internal}
