% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_convenience_internal.R
\name{set_raster_values}
\alias{set_raster_values}
\title{Replacement of non-NA values of a raster}
\usage{
set_raster_values(raster, data)
}
\arguments{
\item{raster}{A \code{raster*} object. All non-NA values of \code{raster}
will be replaced. If \code{raster} is a \code{RasterStack}, each layer has
to have identical \code{na}-cells.}

\item{data}{A \code{data.frame} with as many rows as there are non-NA values
in \code{raster}.}
}
\value{
A \code{RasterLayer} if \code{data} has only one column. A
  \code{RasterBrick} if multiple columns were specified in \code{data}.
  Character and factor data will lead to the creation of factor layers.
}
\description{
Takes \code{raster*} objects as input and replaces all non-NA values with
values specified in a \code{data.frame}. Multiple columns will return
\code{RasterStack}'s.
}
\keyword{internal}
