% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_APCsummary.R
\name{create_oneAPCsummaryTable}
\alias{create_oneAPCsummaryTable}
\title{Internal helper to create a summary table for one estimated GAM model}
\usage{
create_oneAPCsummaryTable(model, dat, apc_range = NULL)
}
\arguments{
\item{model}{Optional regression model estimated with \code{\link[mgcv]{gam}}
or \code{\link[mgcv]{bam}} to estimate a smoothed APC surface. Only used if
\code{y_var} is not
specified.}

\item{dat}{Dataset with columns \code{period} and \code{age}. If \code{y_var}
is specified, the dataset must contain the respective column. If \code{model}
is specified, the dataset must have been used for model estimation with
\code{gam} or \code{bam}.}

\item{apc_range}{Optional list with one or multiple elements with names
\code{"age","period","cohort"} to filter the data. Each element should
contain a numeric vector of values for the respective variable that should
be kept in the data. All other values are deleted.}
}
\value{
\code{data.frame} containing aggregated information on the
individual effects.
}
\description{
Internal helper function to be called in \code{\link{create_APCsummary}}.
This function creates the summary table for one model estimated with
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.
}
