% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crit_val_bounds_sim.R
\name{t_bounds_sim}
\alias{t_bounds_sim}
\title{Critical value bounds stochastic simulation for t-bounds test for no
cointegration}
\usage{
t_bounds_sim(case, k, alpha, T, R = 40000)
}
\arguments{
\item{case}{An integer (1, 3 or 5) specifying whether the 'intercept' and/or
the trend' have to participate in the short-run relationship (see section
'Cases' in \code{\link{bounds_t_test}}).}

\item{k}{The number of independent variables.}

\item{alpha}{A numeric vector between 0 and 1 indicating the significance
level of the critical value bounds. Multiple values can be used.}

\item{T}{An integer indicating the number of observations.}

\item{R}{An integer indicating how many iterations will be used. Default is
40000.}
}
\value{
\code{t_bounds_sim} returns a data frame with the critical value
  bounds for the t-statistic.
}
\description{
\code{t_bounds_sim} simulates the critical value bounds for the t-bounds test
for no cointegration \cite{Pesaran et al. (2001)}.
}
\seealso{
\code{\link{f_bounds_sim}} \code{\link{bounds_t_test}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
\keyword{ts}
