% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catchment_sim.R
\name{catchment_sim}
\alias{catchment_sim}
\title{Simulating catchment areas}
\usage{
catchment_sim(n, area, dist_func = stats::rgamma, ...)
}
\arguments{
\item{n}{number of catchments to be simulated}

\item{area}{square dimension for catchment (if area = 20, then each catchment
dimensions will be 20 x 20)}

\item{dist_func}{distribution function to simulate number of schools, default is stats::rgamma}

\item{...}{additional arguments passed to the distribution function}
}
\value{
A data frame with n rows and the following columns:
\item{catchID}{Unique identifier for each catchment area}
\item{num.schools}{Number of schools in the catchment area}
\item{xStart}{Starting x-coordinate of the catchment area}
\item{xEnd}{Ending x-coordinate of the catchment area}
\item{yStart}{Starting y-coordinate of the catchment area}
\item{yEnd}{Ending y-coordinate of the catchment area}
}
\description{
Function to simulate specified catchments of square area (a x a).
The number of schools in each catchment area is simulated via a specified distribution function,
with gamma distribution as the default.
}
\examples{
# Using default gamma distribution
catch_df1 <- catchment_sim(16, 20, shape = 4.1, rate = 2.7)

# Using normal distribution
catch_df2 <- catchment_sim(16, 20, dist_func = stats::rnorm, mean = 5, sd = 1)

# Using Poisson distribution
catch_df3 <- catchment_sim(16, 20, dist_func = stats::rpois, lambda = 3)
}
