% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csd.r
\name{csd}
\alias{csd}
\title{Cumulative sleep debt.}
\usage{
csd(x, baseline_sleep, reset = 2, plot = TRUE, ylabel, ...)
}
\arguments{
\item{x}{a report period. See report_period().}

\item{baseline_sleep}{a data frame containing the normal sleep duration or baseline by participant.}

\item{reset}{consecutive number of sleep periods that will set as zero the cumulative sleep debt when the total sleep in 24h is greater than the baseline_sleep.
It does not depend on the exceeding duration or credit.}

\item{plot}{a logical variable. By default is TRUE.}

\item{ylabel}{label of the y-axis}

\item{...}{optional parameters}
}
\value{
a data frame and optionally a graph. def is the daily sleep deficiency.
}
\description{
Cumulative sleep debt.
}
\details{
if no reset is desired just set a large value e.g. 1E3. Three cumsum values are computed: cumsum, cumsum_reset and cumsum_actual.
The last one allows the deficiency to be in credit (positive values).
}
\examples{
# Example 1
library(lubridate)
data(act)
act$datime_start <- ymd_hms(act$datime_start)
act$datime_end <- ymd_hms(act$datime_end)

par <- data.frame(subject_ID = 1,
summary_duration_h = 24,
summary_type = "sequential",
summary_start_datime = ymd_hms("2017-12-05 00:00:00 UTC"),
summary_end_datime = ymd_hms("2017-12-15 00:00:00 UTC"))

rep <- report_period(period = par , acti_data = act)

start_date <- act[act$subject_ID==1 & act$interval_type == "FLIGHT" &
act$comments == "SIN-AMS",]$datime_end
sel <- act[act$datime_start >= start_date & act$datime_end <=
start_date + days(10),]

par_afterflight <- data.frame(subject_ID = 1,
summary_duration_h = 24,
summary_type = "sequential",
summary_start_datime = round.POSIXt(start_date, "day"),
summary_end_datime = round.POSIXt(start_date, "day") + days(10))
rep_afterflight <- report_period(period = par_afterflight , acti_data = sel)
baseline <- data.frame(subject_ID = 1, baseline_sleep = mean(rep$total_sleep))
reset <- 2
z <- csd(x = rep_afterflight, baseline_sleep = baseline, reset = 2)
z[[2]]
plot(z[[1]])
# Example 2 with no reset by adding large reset value
csd(x = rep_afterflight, baseline_sleep = baseline, reset = 1E5)
}
