% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_muts.R
\name{.get_3n_context_of_mutations}
\alias{.get_3n_context_of_mutations}
\title{This function finds the tri-nucleotide context of mutations}
\usage{
.get_3n_context_of_mutations(mutations)
}
\arguments{
\item{mutations}{A data frame with the following columns: chr, pos1, pos2, ref, alt, patient
\describe{
    \item{chr}{autosomal chromosomes as chr1 to chr22 and sex chromosomes as chrX and chrY}
    \item{pos1}{the start position of the mutation in base 1 coordinates}
    \item{pos2}{the end position of the mutation in base 1 coordinates}
    \item{ref}{the reference allele as a string containing the bases A, T, C or G}
    \item{alt}{the alternate allele as a string containing the bases A, T, C or G}
    \item{patient}{the patient identifier as a string}
}}
}
\value{
A data frame consisting of the same columns as the original mutations data frame and sorted
by SNVs and Indels with an additional column \code{tag} which indicates the trinucleotide context of
the mutation
}
\description{
This function finds the tri-nucleotide context of mutations
}
