% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoscape.r
\name{prepareCytoscape}
\alias{prepareCytoscape}
\title{Prepare files for building an Enrichment Map in Cytoscape}
\usage{
prepareCytoscape(terms, gmt, file_dir, col.significance)
}
\arguments{
\item{terms}{a data.table with columns 'term.id', 'term.name', 'adjusted.p.val'}

\item{gmt}{an abridged gmt object containing only the pathways that were
found to be significant}

\item{file_dir}{user defined directory to write output files}

\item{col.significance}{a data.table with a column 'term.id' and a column
for each test indicating whether a pathway is signficiant (TRUE) or not
(FALSE) when considering only that column. If contribution==TRUE, use
col.significance=NULL and this will be skipped}
}
\value{
None
}
\description{
This function writes four files that are used to build an network using
Cytoscape and the EnrichmentMap app.
  The four files written are:
  \describe{
    \item{pathways.txt}{A list of significant terms and the
    associated p-value. Only terms with \code{adjusted.p.val <= significant} are
    written to this file}
    \item{subgroups.txt}{A matrix indicating whether the significant
    pathways are found to be significant when considering only one column from
    \code{scores}. A 1 indicates that that term is significant using only that
    column to test for enrichment analysis}
    \item{pathways.gmt}{A Shortened version of the supplied gmt
    file, containing only the terms in pathways.txt}
    \item{legend.pdf}{A legend with colours matching contributions
    from columns in \code{scores}}
  }
}
