% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{extract_afurextent}
\alias{extract_afurextent}
\title{Extract Urban/Rural Extent Raster}
\usage{
extract_afurextent(
  dest_dir = here::here("01_data", "1b_rasters", "urban_extent"),
  overwrite = FALSE
)
}
\arguments{
\item{dest_dir}{A character string specifying the directory to save the
extracted raster file.}

\item{overwrite}{Logical. Whether to overwrite an existing file in the
destination directory. Default is FALSE.}
}
\value{
A character string representing the full path to the extracted raster
  file.
}
\description{
Extracts the `afurextent.asc` raster file from the package's `inst/extdata`
directory to a specified destination.
}
\details{
This function extracts the `afurextent.asc` file from the package's
`extdata` directory, where it is stored as a compressed `.zip` file. It
requires the `raster` package to load the raster file.
}
\examples{
\donttest{
 extract_afurextent(tempdir(), overwrite = TRUE)
}
}
