% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bargraph_twofactor.R
\name{bargraph_twofactor}
\alias{bargraph_twofactor}
\title{Graph: Group FAT2DIC, FAT2DBC, PSUBDIC or PSUBDBC functions column charts}
\usage{
bargraph_twofactor(
  analysis,
  labels = NULL,
  ocult.facet = FALSE,
  ocult.box = FALSE,
  facet.size = 14,
  ylab = NULL,
  width.bar = 0.3,
  sup = NULL
)
}
\arguments{
\item{analysis}{List with DIC, DBC or DQL object}

\item{labels}{Vector with the name of the facets}

\item{ocult.facet}{Hide facets}

\item{ocult.box}{Hide box}

\item{facet.size}{Font size facets}

\item{ylab}{Y-axis name}

\item{width.bar}{Width bar}

\item{sup}{Number of units above the standard deviation or average bar on the graph}
}
\value{
Returns a column chart grouped by facets
}
\description{
Groups two or more column charts exported from FAT2DIC, FAT2DBC, PSUBDIC or PSUBDBC function
}
\examples{
library(AgroR)
data(corn)
a=with(corn, FAT2DIC(A, B, Resp, quali=c(TRUE, TRUE),ylab="Heigth (cm)"))
b=with(corn, FAT2DIC(A, B, Resp, mcomp="sk", quali=c(TRUE, TRUE),ylab="Heigth (cm)"))
bargraph_twofactor(analysis = list(a,b), labels = c("One","Two"),ocult.box = TRUE)
}
