% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/N_analysis.R
\name{Nreg}
\alias{Nreg}
\title{Analysis: Graph for not significant trend}
\usage{
Nreg(
  trat,
  resp,
  ylab = "Dependent",
  xlab = "Independent",
  error = "SE",
  theme = theme_classic(),
  legend.position = "top",
  legend.text = "not~significant",
  point = "all"
)
}
\arguments{
\item{trat}{Numeric vector with dependent variable.}

\item{resp}{Numeric vector with independent variable.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is "top")}

\item{legend.text}{legend text}

\item{point}{defines whether you want to plot all points ("all") or only the mean ("mean")}
}
\value{
The function returns an exploratory graph of segments
}
\description{
Graph for non-significant trend. Can be used within the multicurve command
}
\examples{
library(AgroReg)
data("aristolochia")
attach(aristolochia)
Nreg(trat,resp)
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{non-significant}
