% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_toCSV.R
\name{monitor_toCSV}
\alias{monitor_toCSV}
\title{Convert monitor data as CSV}
\usage{
monitor_toCSV(monitor, includeMeta = TRUE, includeData = TRUE)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{includeMeta}{Logical specifying whether to include \code{monitor$meta}.}

\item{includeData}{Logical specifying whether to include \code{monitor$data}.}
}
\value{
CSV formatted text.
}
\description{
Converts the contents of the \code{monitor} argument to CSV.
By default, the output is a text string with "human readable" CSV that
includes both \code{meta} and \code{data}. When saved as a file, this format
is useful for point-and-click spreadsheet users who want to have everything
on a single sheet.

To obtain a machine parseable CSV string for just the data, you can use
\code{includeMeta = FALSE}. To obtain machine parseable metadata, use
\code{includeData = FALSE}.
}
\examples{
library(AirMonitor)

monitor <-
  Carmel_Valley \%>\%
  monitor_filterDate(20160802, 20160803)

monitor_toCSV(monitor) \%>\% cat()
monitor_toCSV(monitor, includeData = FALSE) \%>\% cat()
monitor_toCSV(monitor, includeMeta = FALSE) \%>\% cat()

}
