% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{plot_dissimilarity_summary}
\alias{plot_dissimilarity_summary}
\title{An area plot summary of the different causes of column dissimilarity between two multiple sequence alignments}
\usage{
plot_dissimilarity_summary(x, scale = TRUE, stack = TRUE, display = TRUE)
}
\arguments{
\item{x}{an object of type "pairwise alignment comparison" (typically the summary file generated by compare_alignments)}

\item{scale}{scale data to proportion of characters that are not conserved gaps (default = TRUE)}

\item{stack}{stacked area plot in stead of line plot (default = TRUE)}

\item{display}{display this plot (default = TRUE)}
}
\description{
An area plot summary of the different causes of column dissimilarity between two multiple sequence alignments
}
\note{
This function generates a detailed breakdown of the differences between the multiple sequence alignments for each column of the reference alignment. For each column, the relative proportions of merges, splits and shifts is plotted as a proportion of characters that are not merely conserved gaps.
}
\examples{
data(reference_alignment)
data(comparison_alignment)
PAC <- compare_alignments(reference_alignment, comparison_alignment)
plot_dissimilarity_summary(PAC, stack=TRUE)

}

