% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaPartSum.R
\name{AlphaPartSum}
\alias{AlphaPartSum}
\title{AlphaPartSum.R}
\usage{
AlphaPartSum(x, map = NULL, remove = TRUE, zeroPath = TRUE,
  call = "AlphaPartSum")
}
\arguments{
\item{x}{summaryAlphaPart, object from the \code{AlphaPart(...)} or \code{summary(AlphaPart(...), ...)} call.}

\item{map}{List, a map of summing paths; see details and examples.}

\item{remove}{Logical, remove original paths or not.}

\item{zeroPath}{Logical, set called path to zero if it does not exist.}

\item{call}{character, for internal use with \code{AlphaPartSubset}).}
}
\value{
An object of class \code{AlphaPart} or \code{summaryAlphaPart} with modified partitions.
Meta information in slot "info" is modified as well.
}
\description{
A function to sum partitions of several paths.
}
\details{
Sometimes partitions of particular paths are very small or we want to sum
paths that have some similarity. These actions are easy to achive manually
but this functions provides a way to do this consistently with the given
object \code{x}.

Arguments \code{map} must be a list of vectors of length at least
two. Vectors of length one are skipped. The idea is that the first element
is the new or existing path into which we add up all the remaining specified
paths, say \code{list(c("A", "B"), c("X", "X", "Y"), c("Z", "X"))} would
imply A = B, X = X + Y, and Z = X = X + Y. Note that once X is changed its
changed value is used in further calculations. Specify different (new) names
for new targets if you want to avoid this.

Be carefull with \code{remove=TRUE}, which is the default setting, as all
partitions defined after the first (target/new) partition in vector in list
will be removed, for example with \code{list(c("A", "B"), c("X", "X", "Y"),
c("Z", "X"))} partitions B and Y will be removed, while X will not be removed
as it is defined as a target/new partition.
}
\examples{
## Small pedigree with additive genetic (=breeding) values
ped <- data.frame(  id=c(  1,   2,   3,   4,   5,   6),
                  fid=c(  0,   0,   2,   0,   4,   0),
                  mid=c(  0,   0,   1,   0,   3,   3),
                  loc=c("A", "B", "A", "B", "A", "A"),
                  gen=c(  1,   1,   2,   2,   3,   3),
                 trt1=c(100, 120, 115, 130, 125, 125),
                 trt2=c(100, 110, 105,  140,  85, 110))

## Partition additive genetic values
(tmp <- AlphaPart(x=ped, colAGV=c("trt1", "trt2")))

## Sum some partitions (working on object of class AlphaPart)
(tmp2 <- AlphaPartSum(x=tmp, map=list(c("X", "A", "B"), c("A", "B"))))

## Summarize by generation
(tmpS <- summary(tmp, by="gen"))

## Sum some partitions (working on object of class summaryAlphaPart)
(tmpS2 <- AlphaPartSum(x=tmpS, map=list(c("X", "A", "B"), c("A", "B"))))

## ... must be equal to
(tmpS3 <- summary(tmp2, by="gen"))
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}} for the main method,
\code{\link[AlphaPart]{summary.AlphaPart}} for summary method that works on output of \code{AlphaPart},
\code{\link[AlphaPart]{AlphaPartSubset}} for subset/keep method
}
