% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyploids.R
\name{doubleGenome}
\alias{doubleGenome}
\title{Double the ploidy of individuals}
\usage{
doubleGenome(pop, keepParents = TRUE, simParam = NULL)
}
\arguments{
\item{pop}{an object of 'Pop' superclass}

\item{keepParents}{should previous parents be used for mother and 
father.}

\item{simParam}{an object of 'SimParam' class}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Creates new individuals with twice the ploidy. 
This function was created to model the formation of tetraploid 
potatoes from diploid potatoes. This function will work on any 
population.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Create individuals with doubled ploidy
pop2 = doubleGenome(pop, simParam=SP)

}
