% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-Pop.R
\docType{class}
\name{MapPop-class}
\alias{MapPop-class}
\alias{[,MapPop-method}
\alias{c,MapPop-method}
\alias{isMapPop}
\title{Raw population with genetic map}
\usage{
\S4method{[}{MapPop}(x, i)

\S4method{c}{MapPop}(x, ...)

isMapPop(x)
}
\arguments{
\item{x}{a 'MapPop' object}

\item{i}{index of individuals}

\item{...}{additional 'MapPop' objects}
}
\description{
Extends \code{\link{RawPop-class}} to add a genetic map.
This is the first object created in a simulation. It is used
for creating initial populations and setting traits in the
\code{\link{SimParam}}.
}
\section{Methods (by generic)}{
\itemize{
\item \code{[}: Extract MapPop by index

\item \code{c(MapPop)}: Combine multiple MapPops

}}
\section{Functions}{
\itemize{
\item \code{isMapPop()}: Test if object is of a MapPop class

}}
\section{Slots}{

\describe{
\item{\code{genMap}}{list of chromosome genetic maps}

\item{\code{centromere}}{vector of centromere positions}

\item{\code{inbred}}{indicates whether the individuals are fully inbred}
}}

