% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importData.R
\name{importGenMap}
\alias{importGenMap}
\title{Import genetic map}
\usage{
importGenMap(genMap)
}
\arguments{
\item{genMap}{genetic map as a data.frame. The first
three columns must be: marker name, chromosome, and 
map position (Morgans). Marker name and chromosome are 
coerced using as.character.}
}
\value{
a list of named vectors
}
\description{
Formats a genetic map stored in a data.frame to
AlphaSimR's internal format. Map positions must be 
in Morgans.
}
\examples{
genMap = data.frame(markerName=letters[1:5],
                    chromosome=c(1,1,1,2,2),
                    position=c(0,0.5,1,0.15,0.4))

asrMap = importGenMap(genMap=genMap)

str(asrMap)

}
