% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{getAmigaBitmapFont}
\alias{getAmigaBitmapFont}
\title{Extract a specific AmigaBitmapFont from a AmigaBitmapFontSet}
\usage{
getAmigaBitmapFont(x, size)
}
\arguments{
\item{x}{An \code{\link{AmigaBitmapFontSet}} object, from which the
specific \code{\link{AmigaBitmapFont}} object needs to be extracted.}

\item{size}{A single \code{numeric} value specifying the desired font
size in pixels. Use \code{\link{availableFontSizes}} to get available
sizes.}
}
\value{
Returns an \code{\link{AmigaBitmapFont}} of the requested size.
An error is thrown when the requested size is not available.
}
\description{
Extract a specific \code{\link{AmigaBitmapFont}} from a
\code{\link{AmigaBitmapFontSet}}.
}
\details{
An \code{\link{AmigaBitmapFontSet}} object can hold one or more
bitmaps for specific font sizes (heights). Use this function to
obtain such a specific \code{\link{AmigaBitmapFont}}.
}
\examples{
\dontrun{
data(font_example)

## get the font object for the first available size:
font <- getAmigaBitmapFont(font_example,
                           availableFontSizes(font_example)[1])
}
}
\seealso{
Other AmigaBitmapFont.operations: \code{\link{AmigaBitmapFont}},
  \code{\link{availableFontSizes}}, \code{\link{c}},
  \code{\link{fontName}}, \code{\link{font_example}},
  \code{\link{rasterToAmigaBitmapFont}},
  \code{\link{rawToAmigaBitmapFontSet}},
  \code{\link{rawToAmigaBitmapFont}},
  \code{\link{read.AmigaBitmapFontSet}},
  \code{\link{read.AmigaBitmapFont}},
  \code{\link{write.AmigaBitmapFont}}
}
\author{
Pepijn de Vries
}
