% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_stat.R
\name{desc_stat}
\alias{desc_stat}
\title{Descriptive Statistics}
\usage{
desc_stat(
  data,
  count = TRUE,
  unique = TRUE,
  duplicate = TRUE,
  null = TRUE,
  null_rate = TRUE,
  type = TRUE,
  min = TRUE,
  p25 = TRUE,
  mean = TRUE,
  median = TRUE,
  p75 = TRUE,
  max = TRUE,
  sd = TRUE,
  skewness = FALSE,
  kurtosis = FALSE,
  shapiro = FALSE,
  kolmogorov = FALSE,
  anderson = FALSE,
  lilliefors = FALSE,
  jarque = FALSE
)
}
\arguments{
\item{data}{input dataset}

\item{count}{An logical argument(default TRUE) that determines if count is included in the output}

\item{unique}{An logical argument(default TRUE) that determines if unique is included in the output}

\item{duplicate}{An logical argument(default TRUE) that determines if duplicate is included in the output}

\item{null}{An logical argument(default TRUE) that determines if null is included in the output}

\item{null_rate}{An logical argument(default TRUE) that determines if null_rate is included in the output}

\item{type}{An logical argument(default TRUE) that determines if type is included in the output}

\item{min}{An logical argument(default TRUE) that determines if min is included in the output}

\item{p25}{An logical argument(default TRUE) that determines if p25 is included in the output}

\item{mean}{An logical argument(default TRUE) that determines if mean is included in the output}

\item{median}{An logical argument(default TRUE) that determines if median is included in the output}

\item{p75}{An logical argument(default TRUE) that determines if p75 is included in the output}

\item{max}{An logical argument(default TRUE) that determines if max is included in the output}

\item{sd}{An logical argument(default TRUE) that determines if sd is included in the output}

\item{skewness}{An logical argument(default FALSE) that determines if skewness is included in the output}

\item{kurtosis}{An logical argument(default FALSE) that determines if kurtosis is included in the output}

\item{shapiro}{An logical argument(default FALSE) that determines if shapiro p-value is included in the output}

\item{kolmogorov}{An logical argument(default FALSE) that determines if kolmogorov p-value is included in the output}

\item{anderson}{An logical argument(default FALSE) that determines if anderson p-value is included in the output}

\item{lilliefors}{An logical argument(default FALSE) that determines if lilliefors p-value is included in the output}

\item{jarque}{An logical argument(default FALSE) that determines if jarque p-value is included in the output}
}
\value{
A data frame which summarizes the characteristics of a data set
}
\description{
desc_stat() function calculates various key descriptive statistics for each
variables in the provided data set. The function computes the count, number of unique values,
duplicate count, number of missing values, null rate, data type, minimum value, 25th percentile,
mean, median, 75th percentile, maximum value, standard deviation, kurtosis, skewness, and jarque_pvalue for each variable.
}
\examples{
data(mtcars)
desc_stat(mtcars)
}
