% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{ImportCSV}
\alias{ImportCSV}
\title{Importing a CSV file containing the output of the MCMC algorithm}
\usage{
  ImportCSV(file, dec = '.', sep=',', comment.char='#', header = TRUE, 
  iterationColumn = NULL, referenceYear = NULL, rowToWithdraw=NULL, bin.width=NULL)
}
\arguments{
  \item{file}{the name of the CSV file containing the output of the MCMC algorithm}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
  \item{header}{a logical value indicating whether the file contains the names of the variables as its first line. }
  \item{iterationColumn}{number of the column corresponding to the iteration values. Default = 1.}
  \item{referenceYear}{the year of reference for MCMC in date format other than BC/AD. Default value = NULL as ChronoModel and Oxacl export the MCMC samples in BC/AD format.}
  \item{rowToWithdraw}{the number of the row to be withdrawn, or "last" for the last row of the data frame. Default = NULL.}
  \item{bin.width}{the bin width specified in a BCal project. Note that bin.width does not have to be set if the BCal default bin width of 1 is used.}
}
\value{
  Returns a dataframe containing a representation of the data in the file. MCMC should now be in date format BC/AD.   
}
\description{
  Use of the read.csv with the default values for CSV files extracted from ChronoModel software. 
  For MCMC in a date format different from BC/AD, use the parameter referenceYear to convert the MCMC in BC/AD otherwise, the remaining functions of this package will not work.
  MCMC files generated by BCAl may contain an empty last row. This row should be withdrawn using the 'rowToWithdraw' parameter. Otherwise, the functions of the package 'ArchaeoPhases' will not work properly.
  }
\author{
    Anne Philippe <Anne.Philippe@univ-nantes.fr>, Thomas S. Dye  <TSD@tsdye.com> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Events)
 # write.csv(Events, "data.csv", row.names=FALSE)
 #  data = ImportCSV("data.csv", dec = '.', sep=',', comment.char='#', header = TRUE,
 #  iterationColumn = 1)
  
  # Import of MCMC generated by BCal and extracted in cal BP (the year of reference is 1950)
  data(Fishpond)
 # write.csv(Fishpond, "fishpond_MCMC.csv", row.names=FALSE)
 #  Fishpond = ImportCSV("fishpond_MCMC.csv", dec = '.', sep=',', header = TRUE, 
 #  iterationColum= 1, referenceYear = 1950, rowToWithdraw = "last")
}
\keyword{ CSV file}
