% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhaseStatistics.R
\name{PhaseStatistics}
\alias{PhaseStatistics}
\title{Summary statistics of a phase}
\usage{
PhaseStatistics(
  PhaseMin_chain,
  PhaseMax_chain,
  level = 0.95,
  roundingOfValue = 0
)
}
\arguments{
\item{PhaseMin_chain}{Numeric vector containing the output of the MCMC
algorithm for the minimum of the dates included in the phase.}

\item{PhaseMax_chain}{Numeric vector containing the output of the MCMC
algorithm for the maximum of the dates included in the phase.}

\item{level}{Probability corresponding to the level of confidence used
for the credible interval and the highest density region.}

\item{roundingOfValue}{Integer indicating the number of decimal places.}
}
\value{
A matrix of values corresponding to the summary statistics:
\describe{
\item{1}{Statistics of the minimum of the dates included in the phase}
\item{2}{Statistics of the maximum of the dates included in the phase}
\item{3}{Statistics of the duration of the dates included in the phase}
}
The results are given in calendar year (in format BC/AD).
}
\description{
Estimation of summary statistics, including the beginning and end
of a phase, and the duration of the phase
}
\details{
The summary statistics are those given by the \code{MarginalStatistics()} function.
The time range is given by \code{PhaseTimeRange()} function.  The duration is computed
as follows: \eqn{duration = maximum - minimum} at each iteration of the MCMC output.
}
\examples{
  data(Phases); attach(Phases)
  PhaseStatistics(Phase.1.alpha, Phase.1.beta, 0.95)
  PhaseStatistics(Phase.2.alpha, Phase.2.beta, 0.95)

}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr} and

Marie-Anne Vibet, \email{Marie-Anne.Vibet@univ-nantes.fr}
}
