% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elapse.R
\docType{methods}
\name{elapse}
\alias{elapse}
\alias{elapse-method}
\alias{elapse,MCMC-method}
\title{Elapsed Time Scale}
\usage{
elapse(object, ...)

\S4method{elapse}{MCMC}(object, origin = 1)
}
\arguments{
\item{object}{An object (typically an \code{\linkS4class{MCMC}} object).}

\item{...}{Currently not used.}

\item{origin}{An \code{\link{integer}} giving the position of the column corresponding
to the event from which elapsed time is calculated.}
}
\value{
Returns an object of the same class as \code{object} with an elapsed

An object of the same sort as \code{object} with a new time scale.
}
\description{
Elapsed Time Scale
}
\note{
There is no year \eqn{0} in BCE/CE scale.
}
\examples{
## Coerce to events
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)

## Elapsed origin
eve_elapse <- elapse(eve, origin = 4)
plot(eve_elapse)
}
\seealso{
Other event tools: 
\code{\link{activity}()},
\code{\link{occurrence}()},
\code{\link{tempo}()}
}
\author{
N. Frerebeau
}
\concept{event tools}
