% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/test.R
\docType{methods}
\name{older}
\alias{older}
\alias{older-method}
\alias{older,numeric,numeric-method}
\alias{older,EventsMCMC,missing-method}
\alias{older,EventsMCMC-method}
\title{Bayesian Test for Anteriority/Posteriority}
\usage{
older(x, y, ...)

\S4method{older}{numeric,numeric}(x, y)

\S4method{older}{EventsMCMC,missing}(x, y)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector giving the output of the MCMC algorithm for the
first parameter, or an \code{\linkS4class{EventsMCMC}} object.}

\item{y}{A \code{\link{numeric}} vector giving the output of the MCMC algorithm for the
second parameter.}

\item{...}{Currently not used.}
}
\description{
A Bayesian test for checking the following assumption: "event \code{x} is older
than event \code{y}".
}
\details{
For a given output of MCMC algorithm, this function estimates the posterior
probability of the event \eqn{x < y} by the relative frequency of the event
"the value of event \code{x} is less than the value of event \code{y}" in the
simulated Markov chain.
}
\section{Methods (by class)}{
\itemize{
\item \code{older(x = numeric, y = numeric)}: Returns a length-one \code{\link{numeric}} vector (the posterior
probability of the assumption: "event \code{x} is older than event \code{y}").

\item \code{older(x = EventsMCMC, y = missing)}: Returns a \code{\link{numeric}} matrix of posterior probabilities.

}}
\examples{
## Coerce to MCMC
eve <- as_events(mcmc_events, calendar = CE(), iteration = 1)
eve <- eve[1:10000, ]

## Test for anteriority
older(eve)

## Test for hiatus
hia <- hiatus(eve)
as.data.frame(hia)
}
\author{
A. Philippe, M.-A. Vibet, N. Frerebeau
}
\concept{tests}
