#' @name Arothron-package
#' @docType package
#' @aliases Arothron
#' @title Geometric Morphometrics Analyses
#' @author Antonio Profico, Alessio Veneziano, Marina Melchionna, Pasquale Raia
#' @description Tools for geometric morphometric analysis. The package includes tools of virtual anthropology to align two not articulated parts belonging to the same specimen, to build virtual cavities as endocast, and functions to import and export the coordinates of landmarks and 3D paths into the 'landmarkAscii' and 'am' format files.
#' @import doParallel
#' @import foreach
#' @import geometry
#' @import graphics
#' @import grDevices
#' @import Morpho
#' @import rgl
#' @import Rvcg
#' @import stats
#' @import stringr
#' @import utils
#' @importFrom grDevices dev.new rainbow
#' @importFrom stats dist kmeans rnorm
#' @importFrom utils read.table write.table
#' @importFrom vegan procrustes
#' @importFrom compositions plot3D
NULL
