% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binner.R
\name{binner}
\alias{binner}
\title{Wrapper for recursive binning}
\usage{
binner(x, y, stopper, splitter, init = halfSplit)
}
\arguments{
\item{x}{numeric vector of the first variable to be binned}

\item{y}{numeric vector of the second variable to be binned}

\item{stopper}{function which accepts a list with elements
`x`, `y`, `bnds`, `expn`, and `n` and returns a logical indicating
whether a split should occur for the bin defined by that list}

\item{splitter}{function which accepts a list of lists with
elements `x`, `y`, `bnds`, `expn`, and `n` and returns a list
where each element is a list of two corresponding to a split of
the bin at that position in the original list}

\item{init}{function like `splitter` applied to the sole first
bin}
}
\value{
A list of lists each with elements `x`, `y`, `bnds`,
`expn`, and `n`.
}
\description{
`binner` is an iterative implementation of a
recursive binary partitioning algorithm which accepts the
splitting and stopping functions that guide partitioning as
arguments.
}
\details{
`binner` creates a two-dimensional histogram of the
sample space of `x` and `y` by recursively splitting partitions of
the data using `splitter` until `stopper` indicates that all
partitions are not to be split. An optional argument `init` gives
the function applied to the first bin containing all points to
initialize the binning algorithm.
}
\examples{
## necessary set up
crits <- makeCriteria(depth >= 4, n < 10, expn <= 5)
stopFn <- function(bns) stopper(bns, crits)
spltFn <- function(bn) maxScoreSplit(bn, chiScores)
## generate data
x <- sample(1:100)
y <- sample(1:100)
## run binner
bins <- binner(x, y, stopper = stopFn, splitter = spltFn)
}
\author{
Chris Salahub
}
