% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch.R
\name{summary.DepSearch}
\alias{summary.DepSearch}
\alias{print.DepSearch}
\alias{plot.DepSearch}
\title{S3 methods for `DepSearch`}
\usage{
\method{summary}{DepSearch}(object, ..., adjustP = FALSE)

\method{print}{DepSearch}(x, ...)

\method{plot}{DepSearch}(
  x,
  ...,
  which = 1:5,
  border = "black",
  buffer = 0.01,
  dropPoints = FALSE,
  colrng = c("steelblue", "white", "firebrick"),
  nbr = NA,
  pch = "."
)
}
\arguments{
\item{object}{`DepSearch` object to summarize}

\item{...}{additional arguments to pass on to the method}

\item{adjustP}{logical: should the p-values be adjusted for
multiple testing?}

\item{x}{object with class `DepSearch`}

\item{which}{indices of binnings to display from `x`, where
binnings are ordered by increasing p-value}

\item{border}{colour of borders to be drawn on the binnings}

\item{buffer}{relative width of empty space separating categories}

\item{dropPoints}{logical: should points be dropped for the plot
of the binnings?}

\item{colrng}{colour range to be passed to `residualFill` for
plotting}

\item{nbr}{number of breaks to be passed to `residualFill` for
plotting}

\item{pch}{point type passed to plot}
}
\value{
Nothing for the plot method, while summary quietly returns
a summary of `DepSearch`
}
\description{
The `summary` and `plot` methods outlined here
support the quick description of an `DepSearch` object.
}
\details{
Methods

For each index in `which`, this function produces a row
of three plots. The first plot is the raw data, the second plot
is the ranks of the data, and the final plot is the binning
contained in the `DepSearch` object.
}
\section{Functions}{
\itemize{
\item \code{summary(DepSearch)}: Summary method for `DepSearch`

\item \code{print(DepSearch)}: Print method for `DepSearch`

\item \code{plot(DepSearch)}: Plot method for `DepSearch`

}}
\author{
Chris Salahub
}
