% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChileAirQuality.R
\name{ChileAirQuality}
\alias{ChileAirQuality}
\title{ChileAirQuality}
\source{
<https://sinca.mma.gob.cl/>
}
\usage{
ChileAirQuality(
  Comunas = "INFO",
  Parametros,
  fechadeInicio,
  fechadeTermino,
  Site = FALSE,
  Curar = TRUE
)
}
\arguments{
\item{Comunas}{data vector containing the names or codes of the monitoring
stations. Available stations: "P. O'Higgins", "Cerrillos 1",
 "Cerrillos", "Cerro Navia", "El Bosque", "Independecia", "La Florida",
  "Las Condes", "Pudahuel", "Puente Alto "," Quilicura "," Quilicura 1 ",
  " Coyhaique I "," Coyhaique II ". To see the full list of stations use ChileAirQuality()}

\item{Parametros}{data vector containing the names of the air quality parameters.
Available parameters: "PM10", "PM25", "CO","SO2", "NOX", "NO2", "NO", "O3",
"temp" (temperature), "RH" (relative humidity), "ws" ( wind speed),
 "wd" (wind direction).}

\item{fechadeInicio}{text string containing the start date of the data request}

\item{fechadeTermino}{text string containing the end date of the data request}

\item{Site}{logical value that allows entering the code of the monitoring
station in the variable "Comunas"}

\item{Curar}{logical value that activates data curation for particulate matter,
nitrogen oxides, relative humidity and wind direction.}
}
\value{
A data frame with air quality data.
}
\description{
function that compiles air quality data from the National Air Quality System (S.I.N.C.A.)
}
\examples{

try({
stations <- ChileAirQuality()
}, silent =TRUE)

try({
data <- ChileAirQuality(Comunas = "El Bosque",
 Parametros = c("PM10", "PM25"), fechadeInicio = "01/01/2020",
  fechadeTermino = "02/01/2020")
}, silent =TRUE)

try({
ChileAirQuality(Comunas = c("EB", "SA"),
Parametros = "PM10", fechadeInicio = "01/01/2020",
fechadeTermino = "01/01/2021", Site = TRUE)
}, silent = TRUE)

}
