% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jwt.R
\name{decode_jwt}
\alias{decode_jwt}
\alias{decode_jwt.AzureToken}
\alias{decode_jwt.Token}
\alias{decode_jwt.character}
\alias{extract_jwt}
\alias{extract_jwt.AzureToken}
\alias{extract_jwt.Token}
\alias{extract_jwt.character}
\title{Get raw access token (which is a JWT object)}
\usage{
decode_jwt(token, ...)

\method{decode_jwt}{AzureToken}(token, type = c("access", "id"), ...)

\method{decode_jwt}{Token}(token, type = c("access", "id"), ...)

\method{decode_jwt}{character}(token, ...)

extract_jwt(token, ...)

\method{extract_jwt}{AzureToken}(token, type = c("access", "id"), ...)

\method{extract_jwt}{Token}(token, type = c("access", "id"), ...)

\method{extract_jwt}{character}(token, ...)
}
\arguments{
\item{token}{A token object. This can be an object of class \code{AzureToken}, of class \code{httr::Token}, or a character string containing the encoded token.}

\item{...}{Other arguments passed to methods.}

\item{type}{For the \code{AzureToken} and \code{httr::Token} methods, the token to decode/retrieve: either the access token or ID token.}
}
\value{
For \code{extract_jwt}, the character string containing the encoded token, suitable for including in a HTTP query. For \code{decode_jwt}, a list containing up to 3 components: \code{header}, \code{payload} and \code{signature}.
}
\description{
Get raw access token (which is a JWT object)
}
\details{
An OAuth token is a \emph{JSON Web Token}, which is a set of base64URL-encoded JSON objects containing the token credentials along with an optional (opaque) verification signature. \code{decode_jwt} decodes the credentials into an R object so they can be viewed. \code{extract_jwt} extracts the credentials from an R object of class \code{AzureToken} or \code{httr::Token}.

Note that \code{decode_jwt} does not touch the token signature or attempt to verify the credentials. You should not rely on the decoded information without verifying it independently. Passing the token itself to Azure is safe, as Azure will carry out its own verification procedure.
}
\seealso{
\href{https://jwt.io}{jwt.io}, the main JWT informational site

\href{https://jwt.ms}{jwt.ms}, Microsoft site to decode and explain JWTs

\href{https://en.wikipedia.org/wiki/JSON_Web_Token}{JWT Wikipedia entry}
}
