% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_scraping.R
\name{get_rugby}
\alias{get_rugby}
\title{Scrape Bath Rugby match dates, kick-off times and results}
\usage{
get_rugby(x)
}
\arguments{
\item{x}{A vector of years of seasons to retrieve records from.}
}
\value{
A data frame of kick-off date-times and match outcomes.
}
\description{
Web scraping function to gather dates and times of Bath Rugby matches, and
 whether or not Bath won, from the
 \href{http://www.bathrugby.com/fixtures-results/results-tables/results-match-reports/}{Bath Rugby website}.\cr\cr
 \emph{Note: This function's code is heavily commented so that if you want
  to, you can use it as a tutorial/guide for writing similar functions of
  your own! You can view the commented code on the GitHub repo
  \href{https://github.com/owenjonesuob/BANEScarparking/blob/master/R/web_scraping.R}{here}}.
}
\examples{
# Return matches from 2016/17 season
rugby <- get_rugby(2017)
\donttest{
# Return matches from 2014/15, 2015/16 seasons
seasons <- c(2015, 2016)
rugby <- get_rugby(seasons)
}
}
