% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.coef.R
\name{confint.coef.bas}
\alias{confint.coef.bas}
\alias{confint}
\title{Compute Credible Intervals for BAS regression coefficients from BAS objects}
\usage{
\method{confint}{coef.bas}(object, parm, level = 0.95, nsim = 10000, ...)
}
\arguments{
\item{object}{a coef.bas object}

\item{parm}{a specification of which parameters are to be given credible
intervals, either a vector of numbers or a vector of names. If missing, all
parameters are considered.}

\item{level}{the probabilty coverage required}

\item{nsim}{number of Monte Carlo draws from the posterior distribution.
Used when number of models is greater than 1.}

\item{...}{other arguments to passed; none currently}
}
\value{
A matrix (or vector) with columns giving lower and upper HPD
credible limits for each parameter. These will be labelled as 1-level)/2 and
1 - (1-level)/2 in percent (by default 2.5 and 97.5).
}
\description{
Uses Monte Carlo simulations using posterior means and standard deviations
of coefficents to generate draws from the posterior distributions and
returns highest posterior density (HPD) credible intervals.  If the number
of models equals one, then use the t distribution to find intervals.  These
currently condition on the estimate of $g$. %% ~~ If necessary, more details
than the description above ~~
}
\note{
For mixture of g-priors these are approximate.  This uses Monte Carlo
sampling so results may be subjet to Monte Carlo variation and larger values
of nsim may be needed to reduce variability. %% ~~further notes~~
}
\examples{


data("Hald")
hald.gprior =  bas.lm(Y~ ., data=Hald, alpha=13,
                            prior="g-prior")
coef.hald = coef(hald.gprior)
confint(coef.hald)
confint(coef.hald, approx=FALSE, nsim=5000)
# extract just the coefficent of X4
confint(coef.hald, parm="X4")


}
\seealso{
Other CI methods: \code{\link{confint.pred.bas}},
  \code{\link{plot.confint.bas}}

Other bas methods: \code{\link{BAS}}, \code{\link{bas.lm}},
  \code{\link{coef.bas}}, \code{\link{confint.pred.bas}},
  \code{\link{diagnostics}}, \code{\link{fitted.bas}},
  \code{\link{force.heredity.bas}},
  \code{\link{image.bas}}, \code{\link{predict.basglm}},
  \code{\link{predict.bas}}, \code{\link{summary.bas}},
  \code{\link{update.bas}}
}
\author{
Merlise A Clyde
}
\keyword{regression}
