% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.basglm}
\alias{predict.basglm}
\title{Prediction Method for an Object of Class basglm}
\usage{
\method{predict}{basglm}(
  object,
  newdata,
  se.fit = FALSE,
  type = c("response", "link"),
  top = NULL,
  estimator = "BMA",
  na.action = na.pass,
  ...
)
}
\arguments{
\item{object}{An object of class "basglm", created by \code{bas.glm}}

\item{newdata}{dataframe, new matrix or vector of data for predictions. May
include a column for the intercept or just the predictor variables.  If a
dataframe, the variables are extracted using model.matrix using the call
that created 'object'.  May be missing in which case the data used for
fitting will be used for prediction.}

\item{se.fit}{indicator for whether to compute se of fitted and predicted
values}

\item{type}{Type of predictions required. The default is  "response" is on the scale of the
response variable, with the alternative being on the linear predictor
scale, `type ='link'`. Thus for a default binomial model
`type = 'response'` gives
the predicted probabilities, while with `'link'`, the estimates
are of log-odds (probabilities on logit scale).}

\item{top}{A scalar integer M.  If supplied, calculate results using the subset of the top M models
based on posterior probabilities.}

\item{estimator}{estimator used for predictions.  Currently supported
options include: \cr 'HPM' the highest probability model \cr 'BMA' Bayesian
model averaging, using optionally only the 'top' models \cr 'MPM' the median
probability model of Barbieri and Berger. \cr 'BPM' the model that is
closest to BMA predictions under squared error loss. BMA may be computed
using only the 'top' models if supplied}

\item{na.action}{function determining what should be done with missing values in newdata.
The default is to predict NA.}

\item{...}{optional extra arguments}
}
\value{
a list of
 \item{fit}{predictions using BMA or other estimators}
 \item{Ypred}{matrix of predictions under model(s)}
 \item{postprobs}{renormalized probabilities of
the top models}
\item{best}{index of top models included}
}
\description{
Predictions under model averaging from a BMA (BAS) object for GLMs
under different loss functions.
}
\details{
This function first calls the predict method for class bas
(linear models) to form predictions on the linear predictor
scale for `BMA`, `HPM`, `MPM` etc. If the estimator is `BMA`
and `type='response'` then the
inverse link is applied to fitted values for type equal `'link'`
and model averaging takes place in the `response` scale. Thus applying
the inverse link to BMA estimate with `type = 'link'` is
not equal to the fitted values for `type = 'response'` under
BMA due to the  nonlinear transformation under the inverse link.
}
\examples{


data(Pima.tr, package="MASS")
data(Pima.te, package="MASS")
Pima.bas = bas.glm(type ~ ., data=Pima.tr, n.models= 2^7, method="BAS",
           betaprior=CCH(a=1, b=nrow(Pima.tr)/2, s=0), family=binomial(),
           modelprior=uniform())
pred = predict(Pima.bas, newdata=Pima.te, top=1)  # Highest Probability model
cv.summary.bas(pred$fit, Pima.te$type, score="miss-class")

}
\seealso{
\code{\link{bas.glm}}, \code{\link{predict.bas}},
\code{\link{fitted.bas}}

Other predict methods: 
\code{\link{fitted.bas}()},
\code{\link{predict.bas}()},
\code{\link{variable.names.pred.bas}()}

Other bas methods: 
\code{\link{BAS}},
\code{\link{bas.lm}()},
\code{\link{coef.bas}()},
\code{\link{confint.coef.bas}()},
\code{\link{confint.pred.bas}()},
\code{\link{diagnostics}()},
\code{\link{fitted.bas}()},
\code{\link{force.heredity.bas}()},
\code{\link{image.bas}()},
\code{\link{plot.confint.bas}()},
\code{\link{predict.bas}()},
\code{\link{summary.bas}()},
\code{\link{update.bas}()},
\code{\link{variable.names.pred.bas}()}
}
\author{
Merlise Clyde
}
\concept{bas methods}
\concept{predict methods}
\keyword{regression}
