% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{kernel.dispersion}
\alias{kernel.dispersion}
\title{Functional dispersion of kernel density hypervolumes.}
\usage{
kernel.dispersion(comm, func = "dissimilarity", frac = 0.1)
}
\arguments{
\item{comm}{A 'Hypervolume' or 'HypervolumeList' object, preferably built using function kernel.build.}

\item{func}{Function for calculating dispersion. One of 'divergence', 'dissimilarity' or 'regression'.}

\item{frac}{A value between 0.01 and 1, indicating the fraction of random points to be used. Default is 0.1.}
}
\value{
A value or vector of dispersion values for each site.
}
\description{
Average distance to centroid or dissimilarity between random points within the boundaries of the kernel density hypervolume.
}
\details{
This function calculates dispersion either: i) as the average distance between stochastic points within the kernel density hypervolume and the centroid of these points (divergence; Laliberte & Legendre, 2010; see also Carmona et al., 2019); ii) as the average distance between all points (dissimilarity, see also function BAT::dispersion); or iii) as the average distance between stochastic points within the kernel density hypervolume and a regression line fitted through the points.
The number of stochastic points is controlled by the 'frac' parameter (increase this number for less deviation in the estimation).
}
\examples{
\dontrun{
comm = rbind(c(1,3,0,5,3), c(3,2,5,1,0))
colnames(comm) = c("SpA", "SpB", "SpC", "SpD", "SpE")
rownames(comm) = c("Site 1", "Site 2")

trait = data.frame(body = c(1,2,3,4,4), beak = c(1,5,4,1,2))
rownames(trait) = colnames(comm)

hv = kernel.build(comm[1,], trait)
kernel.dispersion(hv)
hvlist = kernel.build(comm, trait, axes = 2)
kernel.dispersion(hvlist)
kernel.dispersion(hvlist, func = "divergence")
}
}
\references{
Carmona, C.P., de Bello, F., Mason, N.W.H. & Leps, J. (2019) Trait probability density (TPD): measuring functional diversity across scales based on TPD with R. Ecology, 100: e02876.

Laliberte, E. & Legendre, P. (2010) A distance-based framework for measuring functional diversity from multiple traits. Ecology 91: 299-305.
}
