% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraping_rosters_acb.R
\name{scraping_rosters_acb}
\alias{scraping_rosters_acb}
\title{ACB players' profile}
\usage{
scraping_rosters_acb(pcode, verbose = TRUE, accents = FALSE, 
                     r_user = "guillermo.vinue@uv.es")
}
\arguments{
\item{pcode}{Code corresponding to the player's website to scrape.}

\item{verbose}{Should R report information on progress? Default TRUE.}

\item{accents}{Should we keep the Spanish accents? The recommended 
option is to remove them, so default FALSE.}

\item{r_user}{Email user to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
Data frame with eight columns: 
\itemize{
\item CombinID: Unique ID to identify the players.
\item Player: Player's name.
\item Position: Player's position on the court.
\item Height: Player's height.
\item Date_birth: Player's birth date.
\item Nationality: Player's nationality.
\item Licence: Player's licence.
\item Website_player: Website.
}
}
\description{
This function allows us to obtain the basic information of each player, 
including his birth date. Then, we will be able to compute the age that 
each player had in the date that he played each game. 
The website used to collect information is \url{www.acb.com}.
}
\details{
Some players have a particular licence, which does not necessarily match with their
nationality, in order not to be considered as a foreign player, according to the 
current ACB rules.
}
\note{
In addition to use the email address to stay identifiable, the function also 
contains two headers regarding the R platform and version used.

Furthermore, even though in the robots.txt file at 
\url{http://www.acb.com/robots.txt}, there is no information about scraping
limitations and all robots are allowed to have complete access,
the function also includes the command \code{Sys.sleep(2)}
to pause between requests for 2 seconds. In this way, we don't bother the server 
with multiple requests and we do carry out a friendly scraping.
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
df_bio <- scraping_rosters_acb("56C", verbose = TRUE, accents = FALSE, 
                               r_user = "guillermo.vinue@uv.es")
}

}
\seealso{
\code{\link{do_scraping_rosters}}
}
\author{
Guillermo Vinue
}
