% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_barplot_monthly_stats.R
\name{get_barplot_monthly_stats}
\alias{get_barplot_monthly_stats}
\title{Barplots with monthly stats}
\usage{
get_barplot_monthly_stats(df_stats, title, size_text = 2.5)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{title}{Plot title.}

\item{size_text}{Label size for each bar. Default 2.5.}
}
\value{
Graphical device.
}
\description{
In all the available basketball websites, the stats are presented for the whole
number of games played. This function represents a barplot with the players' stats 
for each month, which is very useful to analyse the players' evolution.
}
\examples{
\dontrun{
library(dplyr)
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)
df1 <- do_add_adv_stats(df)

months <- c(df \%>\% distinct(Month))$Month
months_order <- c("septiembre", "octubre", "noviembre", "diciembre", "enero")
months_plot <- match(months_order, months)
months_plot1 <- months_plot[!is.na(months_plot)]
months_plot2 <- months[months_plot1]

df3_m <- df1 \%>\%
filter(Team == "Real_Madrid", 
      Player.x == "Doncic, Luka") \%>\%
 group_by(Month) \%>\%
 do(do_stats(., "Average", "2017-2018", "ACB", "Regular Season")) \%>\%
 ungroup() \%>\%
 mutate(Month = factor(Month, levels = months_plot2)) \%>\%
 arrange(Month)

stats <- c("GP", "MP", "PTS", "FGA", "FGPerc", "ThreePA", 
           "ThreePPerc", "FTA", "FTPerc",
           "TRB", "ORB", "AST", "TOV", "STL")
           
df3_m1 <- df3_m \%>\%
  select(1:5, all_of(stats), 46:50) \%>\%
  mutate(Month = plyr::mapvalues(Month, 
                                 from = c("octubre", "noviembre", "diciembre", "enero"),
                                 to = c("October", "November", "December", "January")))
  
get_barplot_monthly_stats(df3_m1, paste("ACB", "2017-2018", "Average", sep = " ; "), 2.5)

# For all teams and players:
teams <- as.character(sort(unique(df1$Team)))
df3_m <- df1 \%>\%
filter(Team == teams[13]) \%>\%
 group_by(Month) \%>\%
 do(do_stats(., "Average", "2017-2018", "ACB", "Regular Season")) \%>\%
 ungroup() \%>\%
 mutate(Month = factor(Month, levels = months_plot2)) \%>\%
 arrange(Month)

df3_m1 <- df3_m \%>\%
  select(1:5, all_of(stats), 46:50) \%>\%
  mutate(Month = plyr::mapvalues(Month, 
                                 from = c("octubre", "noviembre", "diciembre", "enero"),
                                 to = c("October", "November", "December", "January")))

for (i in unique(df3_m1$Name)) {
  print(i)
  print(get_barplot_monthly_stats(df3_m1 \%>\% filter(Name == i), 
                                  paste("ACB", "2017-2018", "Average", sep = " ; "), 
                                  2.5))
}
}

}
\seealso{
\code{\link{capit_two_words}}
}
\author{
Guillermo Vinue
}
