% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BB_SSL.R
\name{BB_SSL}
\alias{BB_SSL}
\title{BB-SSL}
\usage{
BB_SSL(y, X, method = 3, lambda, NSample, a, b, maxiter=500, eps = 1e-3, burn.in = FALSE,
length.out = 50, discard = FALSE, alpha = 3, sigma = 1, initial.beta,
penalty = "adaptive", theta=0.5)
}
\arguments{
\item{y}{A vector of continuous responses (n x 1).}

\item{X}{The design matrix (n x p), without an intercept.}

\item{method}{A number between c(1,2,3) to specify which method to run, method = 1 is fixed WBB, method = 2 is random WBB, method = 3 is BB-SSL.}

\item{lambda}{A two-dim vector = c(lambda0, lambda1).}

\item{NSample}{An integer which specifies the number of samples to be generated.}

\item{a, b}{Parameters of the prior.}

\item{maxiter}{An integer which specifies the maximum number of iterations for SSLASSO_2 (default maxiter= 500).}

\item{eps}{Convergence criterion when running SSLASSO_2: converged when difference in regression coefficients is less than eps (default eps = 0.001).}

\item{burn.in}{A boolean to specify whether to use annealing on a sequence of lambda0's (default burn.in = FALSE).}

\item{length.out}{An integer to specify the length of sequence of lambda0's used in annealing. This value is not used when burn.in = FALSE. Default is 50.}

\item{discard}{A boolean to specify whether to discard unconverged sample points.}

\item{alpha}{The parameter for generating weights in BB-SSL, which follows n x Dirichlet(alpha,...,alpha). Default is 3.}

\item{sigma}{Noise standard deviation.}

\item{initial.beta}{A vector of initial values of beta to used when solving SSLASSO_2 (n x 1).}

\item{penalty}{The penalty (prior) to be applied to the model. Either "separable" (with a fixed theta) or "adaptive" (with a random theta, where theta ~ B(a,p)). The default is "adaptive".}

\item{theta}{Prior mixing proportion. For "separable" penalty, this value is fixed. For "adaptive" penalty, this value is used as a starting value. Default is 0.5.}
}
\value{
A list of matrices, including matrix beta (NSample x p) and matrix gamma (NSample x p).
}
\description{
This function runs BB-SSL, WBB with fixed prior weight, and WBB with random prior weight.
It solves the optimization by calling function SSLASSO_2, a variant of the function SSLASSO in CRAN package 'SSLASSO': in the version used,
we do NOT standardize the design matrix and allow inputting initial values of beta's.
}
\examples{
# -------------- Generate Data --------------
n = 50; p = 12;
truth.beta = c(1.3, 1.3, 1.3, 1.3);
truth.sigma = 1
data = Generate_data(truth.beta, p, n, truth.sigma = 1, rho = 0.6,"block",4)
y = data$y; X = data$X; beta = data$beta

# --------------- set parameters -----------------
lambda0 = 7; lambda1 = 0.15; lambda = c(lambda0, lambda1)
a = 1; b = p #beta prior for theta



#--------------- BB-SSL -------------
# this is for demonstration of usage only
# in practice, you may want to use more iterations!
BB.SSL.result = BB_SSL(y, X, method = 3, lambda = c(lambda0, lambda1), NSample = 100, a, b,
maxiter = 500, length.out = 50, burn.in = FALSE, discard = TRUE, alpha=1,
initial.beta = rep(0,p))

# Alternatively, you can use SSLASSO_2 solution to get an initial value of beta's
result = SSLASSO_2(X, y, penalty = "adaptive", variance = "fixed", sigma = truth.sigma,
                   lambda1 = lambda1, lambda0 = seq(lambda1, lambda0, length.out = 50),
                   a = a, b = b,
                   max.iter = 500, initial.beta = rep(0,p))

fixed.WBB.result = BB_SSL(y, X, method = 1, lambda = c(lambda0, lambda1), NSample = 100,
                          a, b, maxiter = 500, length.out = 50, burn.in = FALSE,
                          discard = TRUE, initial.beta = result$beta[,50])

random.WBB.result = BB_SSL(y, X, method = 2, lambda = c(lambda0, lambda1), NSample = 100,
                           a, b, maxiter = 500, length.out = 50, burn.in = FALSE,
                           discard = TRUE, initial.beta = result$beta[,50])

BB.SSL.result = BB_SSL(y, X, method = 3, lambda = c(lambda0, lambda1), NSample = 100, a,
                       b, maxiter = 500, length.out = 50, burn.in = FALSE, discard = TRUE,
                       alpha=1, initial.beta = result$beta[,50])

}
\references{
Nie, L., & Ročková, V. (2020). Bayesian Bootstrap Spike-and-Slab LASSO. arXiv:2011.14279.

Newton, M. A., Polson, N. G., and Xu, J. (2020). Weighted Bayesian bootstrap for scalable
posterior distributions. Canadian Journal of Statistics (In Press).
}
\author{
Lizhen Nie \href{mailto:lizhen@statistics.uchicago.edu}{lizhen@statistics.uchicago.edu}, Veronika Rockova \href{mailto:Veronika.Rockova@chicagobooth.edu}{Veronika.Rockova@chicagobooth.edu}
}
