% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbcor.R
\name{bbcor}
\alias{bbcor}
\title{Bayesian Bootstrapping Correlations}
\usage{
bbcor(x, method = "pearson", iter = 5000, cores = 2)
}
\arguments{
\item{x}{A matrix of dimensions \emph{n} by \emph{p}}

\item{method}{Character string. Which correlation coefficient should be computed. 
One of "pearson" (default), "kendall", "spearman", "gaussian_rank", or "blomqvist"
(i.e., median correlation).}

\item{iter}{Numeric. How many posterior samples (defaults to \code{5000}) ?}

\item{cores}{Numeric. How many cores for parallel computing (defaults to \code{2})?}
}
\value{
\itemize{
\item \code{cor_mean}: A matrix including the posterior mean

\item \code{samps}: An array of dimensions \code{p} by \code{b} by \code{iter} that includes the 
sampled correlation matrices.

}
}
\description{
Efficiently draws samples from the posterior 
             distribution of various correlation coefficients
}
\note{
NAs are removed.
}
\examples{

Y <- mtcars[,1:2]

bb_samps <- bbcor(Y, method = "spearman")

}
