% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptreject_DAG.R
\name{acceptreject_DAG}
\alias{acceptreject_DAG}
\title{Accept/reject the proposed DAG given the current DAG (internal function)}
\usage{
acceptreject_DAG(
  tXX,
  n,
  currentDAG,
  proposedDAG,
  node,
  op.type,
  a,
  U,
  w,
  current.opcard,
  proposed.opcard
)
}
\arguments{
\item{tXX}{\eqn{(q,q)} matrix \eqn{X'X} with \eqn{X} the \eqn{(n,q)} data matrix}

\item{n}{number of observations (rows) in the data matrix \eqn{X}}

\item{currentDAG}{\eqn{(q,q)} adjacency matrix of current DAG}

\item{proposedDAG}{\eqn{(q,q)} adjacency matrix of proposed DAG}

\item{node}{nodes \eqn{u} and \eqn{v} involved in the modified edge \eqn{u -> v}}

\item{op.type}{the type of operator applied to \code{currentDAG} to obtain \code{proposedDAG}}

\item{a}{shape hyperparameter of the DAG Wishart prior}

\item{U}{position hyperparameter of the DAG Wishart prior}

\item{w}{prior probability of edge inclusion}

\item{current.opcard}{number of direct successors of \code{currentDAG}}

\item{proposed.opcard}{number of direct successors of \code{proposedDAG}}
}
\value{
A Boolean indicating whether \code{proposedDAG} has been accepted (\code{TRUE}) or not (\code{FALSE})
}
\description{
This function computes the Metropolis Hastings acceptance rate for \code{proposedDAG} given \code{currentDAG}
and the accepts/rejects \code{proposedDAG} based on the Metropolis Hastings acceptance probability.
\code{proposedDAG} is a direct successor of \code{currentDAG}, which was obtained by applying an operator of type InsertD, DeleteD or ReverseD to \code{currentDAG}.
The two DAGs only differ by one edge \eqn{u -> v} which has been inserted/deleted/reversed in \code{currentDAG}.
}
