% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bcdag.R
\name{summary.bcdag}
\alias{summary.bcdag}
\title{bcdag object summaries}
\usage{
\method{summary}{bcdag}(object, ...)
}
\arguments{
\item{object}{a \code{bcdag} object for which a summary is desired}

\item{...}{additional arguments affecting the summary produced}
}
\value{
A printed message listing the inputs given to learn_DAG, a graphical representation of the Median Probability DAG, a heatmap representing posterior probability of edge inclusion and an histogram of the number of edges in the visited DAGs.
}
\description{
bcdag object summaries
}
\examples{
n <- 1000
q <- 4
DAG <- matrix(c(0,1,1,0,0,0,0,0,0,0,0,0,0,1,1,0), nrow = q)

L <- DAG
L[L != 0] <- runif(q, 0.2, 1)
diag(L) <- c(1,1,1,1)
D <- diag(1, q)
Sigma <- t(solve(L))\%*\%D\%*\%solve(L)

a <- 6
g <- 1/1000
U <- g*diag(1,q)
w = 0.2

set.seed(1)
X <- mvtnorm::rmvnorm(n, sigma = Sigma)

out <- learn_DAG(1000, 0, X, a, U, w, fast = TRUE, collapse = TRUE, save.memory = FALSE)
summary(out)
}
