% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/targeting_motiv.R
\name{targeting_motiv}
\alias{targeting_motiv}
\title{Function to calculate the procentual difference at 6 positions to a nucleotide mutation to identify the hotspot motifs}
\usage{
targeting_motiv(data)
}
\arguments{
\item{data}{Output from the function hotspotmutMat().}
}
\value{
Output is a list of four mutation environments A, C, T and G with the percentage difference of the nucleotides A, C, T and G at six positions to a mutation.
}
\description{
Function to calculate the procentual difference at 6 positions to a nucleotide mutation to identify the hotspot motifs
}
\examples{
##data(IMGTtab2) data(IMGTtab7)
germline<-germlineReconstr(IMGTtab2$V_REGION, IMGTtab7$V_REGION)
data<-targetingMatrix(data_tab2=IMGTtab2, data_tab_germline=germline, data_tab7=IMGTtab7)
targeting_motiv_data<-targeting_motiv(data)
targeting_motiv_data
}
\references{
Spencer J. and Dunn-Walters DK.  Hypermutation at A-T base pairs: the A nucleotidereplacement spectrum is affected by adjacent nucleotides and there is no reverse comple-mentary of sequences flanking muated A and T nucleotides.J Immunol, 175(8):5170 - 5177,2005.

Zuckerman NS., Hazanov H., Barak M., Edelman H., Hess S., Shcolnik H., Dunn-Walters D.,and Mehr R. Somatic hypermutation and antigen-driven selection of B cells are altered inautoimmune diseases.J Autoimmun, 35(4):325 - 335, 2010. doi: 10.1016/j.jaut.2010.07.004.
}

