% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsize.R
\name{fsize}
\alias{fsize}
\title{Detectable minimum effect size}
\usage{
fsize(alpha,beta,nu1,nu2,c,delta_type,flag)
}
\arguments{
\item{alpha}{Type I error}

\item{beta}{Type II error}

\item{nu1}{numerator degree of freedom for the f-test}

\item{nu2}{denominator degree of freedom for the f-test}

\item{c}{the coefficient of sum of squares}

\item{delta_type}{type of standardized effect size ; 1 : standard deviation type, 2 : range of effect type}

\item{flag}{In case of delta_type=2 ; If flag=1 , two-way interaction effect for range of effect type. If flag=0(default), main effect for range of effect type.}
}
\value{
detectable minimal effect sizes
}
\description{
Detectable minimum effect size is calculated using the distribution function of noncentral F-distribution with noncentrality parameter.
}
\examples{
#two-level full factorial design with 2 factors
#5 replications, main effect for standardized type
fsize(alpha=0.05, beta=0.2, nu1=1, nu2=17,
c=10,delta_type=1 )

}
