% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beIDsToAllScopes.R
\name{beIDsToAllScopes}
\alias{beIDsToAllScopes}
\title{Find all BEID and ProbeID corresponding to a BE}
\usage{
beIDsToAllScopes(
  beids,
  be,
  source,
  organism,
  entities = NULL,
  canonical_symbols = TRUE
)
}
\arguments{
\item{beids}{a character vector of gene identifiers}

\item{be}{one BE. \strong{Guessed if not provided}}

\item{source}{the source of gene identifiers. \strong{Guessed if not provided}}

\item{organism}{the gene organism. \strong{Guessed if not provided}}

\item{entities}{a numeric vector of gene entity. If NULL (default),
beids, source and organism arguments are used to identify BEs.
Be carefull when using entities as these identifiers are not stable.}

\item{canonical_symbols}{return only canonical symbols (default: TRUE).}
}
\value{
A data.frame with the following fields:
\itemize{
\item \strong{value}: the identifier
\item \strong{be}: the type of BE
\item \strong{source}: the source of the identifier
\item \strong{organism}: the BE organism
\item \strong{symbol}: canonical symbol of the identifier
\item \strong{BE_entity}: the BE entity input
\item \strong{BEID} (optional): the BE ID input
\item \strong{BE_source} (optional): the BE source input
}
}
\description{
Find all BEID and ProbeID corresponding to a BE
}
