% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FUNCTIONS_test_statistics.R
\name{BFF_chi2_test}
\alias{BFF_chi2_test}
\title{BFF_chi2_test}
\usage{
BFF_chi2_test(chi_stat, df, n, count = TRUE, savename = NULL)
}
\arguments{
\item{chi_stat}{chi^2 statistic}

\item{df}{Degrees of freedom}

\item{n}{Sample size}

\item{count}{Is this a test of Pearson’s chi^2 test for goodness-of-fit? Default is TRUE. FALSE assumes a likelihiood ratio test}

\item{savename}{Name of pdf file to save. Requires .pdf extension. Required if saving plot}
}
\value{
Returns Bayes factor function results
 \tabular{ll}{
   \code{BFF} \tab Bayes Factor Function values \cr
   \tab \cr
   \code{effect_size} \tab Effect sizes tested (seq(0, 1, by = 0.01)) \cr
   \tab \cr
   \code{max_BFF} \tab Maximum BFF value \cr
   \tab \cr
   \code{max_RMSE} \tab Effect size that maximizes BFF\cr
}
}
\description{
Bayes Factor function test for the chi^2 statistic. Computes the Bayes factor in favor of the
alternative given a chi^2 statistic, the degrees of freedom, and sample size. The plot shown
when running the function is saved to "BFF_plot.pdf."
}
\examples{
BFF_chi2_test(chi_stat = 3.7, df = 10, n = 100)
}
