% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfs_get_data_comments.R
\name{bfs_get_data_comments}
\alias{bfs_get_data_comments}
\title{Get the comments/footnotes of a BFS dataset in a given language}
\usage{
bfs_get_data_comments(
  number_bfs,
  language = "de",
  query = NULL,
  clean_names = FALSE,
  delay = NULL
)
}
\arguments{
\item{number_bfs}{The BFS number of a dataset.}

\item{language}{Language of the dataset to be translated if exists, i.e. "de", "fr", "it" or "en".}

\item{query}{a list with named values, a json query file or json query string using \code{pxweb::pxweb_query()}.}

\item{clean_names}{Clean column names using \code{janitor::clean_names()}}

\item{delay}{Integer Number of seconds to wait before query using \code{Sys.sleep()}.}
}
\value{
A tbl_df (a type of data frame; see tibble or
dplyr packages).
}
\description{
Get the comments/footnotes of a BFS dataset using PXWEB BFS API v1.
}
\seealso{
\code{\link{bfs_get_data}}
}
