% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{diagnostics}
\alias{diagnostics}
\title{Regression Diagnostic Plots for \code{estimate} Objects}
\usage{
diagnostics(object, iter = 500, ...)
}
\arguments{
\item{object}{object of class \code{estimate}}

\item{iter}{iterations used for computing residuals and fitted values}

\item{...}{currently ignored}
}
\value{
list of \code{ggplot} objects (a plot for each node)
}
\description{
GGMs have a direct correspondence to multiple regression. Hence this function
provides diagnostic plots for inspecting the fitted regression models. This allows for
visually inspecting assumptions of the model (e.g., normality of the residuals, etc.)
}
\examples{
\donttest{
# data
Y <- subset(tas, gender == "M")[,-ncol(tas)]

# fit model
fit <- estimate(Y)

# diagnostic plot (iter = 10 as an example)
diagnostics(fit, iter = 10)
}
}
