% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.ggm_compare_bf.R
\name{plot.select.ggm_compare_bf}
\alias{plot.select.ggm_compare_bf}
\title{Plot \code{select.ggm_compare_bf} Objects}
\usage{
\method{plot}{select.ggm_compare_bf}(
  x,
  H0_low = "lightblue",
  H0_high = "purple",
  H1_low = "yellow",
  H1_high = "red",
  ...
)
}
\arguments{
\item{x}{object of class \code{select.ggm_compare_bf}}

\item{H0_low}{tile color for the smallest Bayes factors in the null hypothesis heatmap}

\item{H0_high}{tile color for the largest Bayes factors in the null hypothesis heatmap}

\item{H1_low}{tile color for the smallest Bayes factors in the alternative hypothesis heatmap}

\item{H1_high}{tile color for the largest Bayes factors in the alternative hypothesis heatmap}

\item{...}{currently ignored}
}
\value{
list containing two \code{ggplot} objects
}
\description{
This function plots the selected graph when comparing GGMs with Bayesian hypothesis
testing. There are two heatmap plots in total. The first includes egdes for which there was
evidence for a diffirence. The second includes edges for which there is evidence for the null
hypothesis of equality. The tiles in the heatmap correspond to the Bayes factor
}
\examples{
\donttest{
# group 1
Y1 <- MASS::mvrnorm(500, mu = rep(0,16),
                    Sigma =  BGGM::ptsd_cor2,
                    empirical = FALSE)

# group 2
Y2 <- MASS::mvrnorm(500, mu = rep(0,16),
                    Sigma =  BGGM::ptsd_cor2,
                    empirical = FALSE)
# fit model
fit <- ggm_compare_bf(Y1, Y2,
                     prior_sd = 0.20,
                     iter = 50,
                     cores = 2)
# select E
E <- select(fit, BF_cut = 3)

# plot E
plot(E)
}
}
