% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm_compare_estimate.default.R
\name{plot.summary.ggm_compare_estimate}
\alias{plot.summary.ggm_compare_estimate}
\title{Plot \code{summary.ggm_compare_estimate} Objects}
\usage{
\method{plot}{summary.ggm_compare_estimate}(x, color = "black", size = 2, width = 0, ...)
}
\arguments{
\item{x}{An object of class \code{ggm_compare_estimate}.}

\item{color}{Character string. The color of the points
(defaults to \code{"black"}).}

\item{size}{Numeric. The size of the points (defaults to 2).}

\item{width}{Numeric. The width of error bar ends (defaults to \code{0}).}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{ggplot}
}
\description{
Visualize the posterior distribution differences.
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes
# data
Y <- bfi

# males and females
Ymale <- subset(Y, gender == 1,
                select = -c(gender,
                            education))[,1:5]

Yfemale <- subset(Y, gender == 2,
                  select = -c(gender,
                              education))[,1:5]

# fit model
fit <- ggm_compare_estimate(Ymale,  Yfemale,
                            type = "ordinal",
                            iter = 250,
                            prior_sd = 0.25,
                            progress = FALSE)

plot(summary(fit))
}

}
\seealso{
\code{\link{ggm_compare_estimate}}
}
