% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizePedigree.R
\name{summarizePatrilines}
\alias{summarizePatrilines}
\title{Summarize the paternal lines in a pedigree}
\usage{
summarizePatrilines(
  ped,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  patID = "patID",
  byr = NULL,
  founder_sort_var = NULL,
  include_founder = FALSE,
  nbiggest = 5,
  noldest = 5,
  skip_var = NULL,
  five_num_summary = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{famID}{character.  Name of the column to be created in ped for the family ID variable}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{matID}{Character.  Maternal line ID variable to be created and added to the pedigree}

\item{patID}{Character.  Paternal line ID variable to be created and added to the pedigree}

\item{byr}{Optional column name for birth year.}

\item{founder_sort_var}{The variable to sort the founders by. If NULL, the founders will be sorted by birth year (`byr`) if that's present and by `personID` otherwise.}

\item{include_founder}{Logical, if TRUE, include the founder of each line in the summary statistics.}

\item{nbiggest}{The number of biggest lines to return.}

\item{noldest}{The number of oldest lines to return.}

\item{skip_var}{A character vector of variables to skip when calculating summary statistics.}

\item{five_num_summary}{Logical, if TRUE, include the 5-number summary (min, Q1, median, Q3, max) in the summary statistics.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\description{
Summarize the paternal lines in a pedigree
}
\seealso{
[summarizePedigrees ()]
}
