% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkIDs.R
\name{checkIDs}
\alias{checkIDs}
\title{Validates and Optionally Repairs Unique IDs in a Pedigree Dataframe}
\usage{
checkIDs(ped, verbose = FALSE, repair = FALSE)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with columns `ID`, `dadID`, and `momID`.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{repair}{A logical flag indicating whether to attempt repairs on non-unique IDs.}
}
\value{
Depending on `repair` value, either returns a list containing validation results or a repaired dataframe
}
\description{
This function takes a pedigree object and performs two main tasks:
1. Checks for the uniqueness of individual IDs.
2. Optionally repairs non-unique IDs based on a specified logic.
}
\examples{
\dontrun{
ped <- data.frame(ID = c(1, 2, 2, 3), dadID = c(NA, 1, 1, 2), momID = c(NA, NA, 2, 2))
checkIDs(ped, verbose = TRUE, repair = FALSE)
}
}
